function generateBarcode() {
  const url = document.getElementById("urlInput").value.trim();
  const format = document.getElementById("barcodeFormat").value;
  const lineColor = document.getElementById("lineColor").value;
  const background = document.getElementById("bgColor").value;
  const displayValue = document.getElementById("displayValue").value === "true";

  if (url) {
    try {
      JsBarcode("#barcode", url, {
        format: format,
        lineColor: lineColor,
        background: background,
        displayValue: displayValue,
        margin: 10,
      });
      document.getElementById("barcode-box").style.display = "block";
    } catch (e) {
      document.getElementById("barcode-box").style.display = "none";
      let msg = "Invalid input for " + format + " format.";
      if (format === "EAN13") {
        msg += "\n\nEAN-13 requires exactly 12 or 13 numeric digits.";
      } else if (format === "UPC") {
        msg += "\n\nUPC requires exactly 11 or 12 numeric digits.";
      } else if (format === "CODE39") {
        msg +=
          "\n\nCode 39 supports uppercase letters, numbers, and symbols (- . $ / + % space).";
      }
      alert(msg);
    }
  }
}
